#!/bin/bash

if test "$1" = "?"; then
    echo "Evaluate results of ngspice \"paranoia\" test suite"
    echo "Format: $0 [ngspice executable]"
    exit 1
fi

NGSPICE="$1"
NGSPICE="${NGSPICE:-ngspice}"

# Check the results
# Find correct response: ngspice-<version> done
NGSPICE_OK="`$NGSPICE -v | awk '/level/ {print $2;}'` done"

echo "*******************************************"
echo  "vlog files with errors found by valgrind:"
grep -L "ERROR SUMMARY: 0 errors from 0 context" ./*.vlog
echo  "*******************************************"
echo "log files with ngspice errors:"
grep -L "$NGSPICE_OK" ./*.log
echo "*******************************************"
echo "log files with convergence issues:"
grep -l "Too many iterations without convergence" ./*.log
echo "*******************************************"
echo "log files with messages containing 'error':"
grep -i -l "error" ./*.log
echo "*******************************************"
